<?php
require('connection.inc.php');
require('functions.inc.php');

$trackingNumber = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Include database connection code here
   

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Sanitize the input
    $trackingNumber = mysqli_real_escape_string($conn, $_POST["trackingNumber"]);

    // Query to fetch status from bill table
    $sql = "SELECT * FROM bill WHERE tracking_num = '$trackingNumber'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
    }

    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hasap yzarlamasy</title>
    <!-- Include Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">

</head>

<body>
    <!-- nav   -->
    <nav class="navbar navbar-expand-sm bg-dark navbar-dark">
    <div class="container-fluid">
      <a class="navbar-brand" href="home.php">Mary poçta</a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#collapsibleNavbar">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="collapsibleNavbar">
        <ul class="navbar-nav">
          <li class="nav-item">
            <a class="nav-link" href="home.php">Baş sahypa</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="user_tracking.php">Poçtaňyzy yzarlaň</a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="about.php">Biz barada</a>
          </li>  
          <li class="nav-item">
            <a class="nav-link" href="logout.php">Ulgamdan çykmak</a>
          </li>  
          <li class="nav-item">
            <a class="nav-link" href="contact.php">Habarlaşmak</a>
          </li>  
         
        </ul>
      </div>
    </div>
  </nav>
      
    <main id="main" class="main">
        <div class="container mt-5 border-2">
            <!-- <section class="section"> -->
            </section>
            <h2>Hasabyň ýagdaýyny yzarlaň</h2>
            <form method="post" class="border border-4">
                <div class="mb-3">
                    <label for="trackingNumber" class="form-label">Gözleg belgisini giriziň:</label>
                    <input type="text" class="form-control" id="trackingNumber" name="trackingNumber" required>
                </div>
                <button type="submit" class="btn btn-primary">Yzarla</button>
                <br>
                <br>
            </form>
        </div>
        <div class="container mt-5">
            <?php if ($trackingNumber !== "" && isset($row)) : ?>
            <div class="row">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Gözleg belgisi:
                            <?php echo $row['tracking_num'] ?>
                        </h5>
                        <p class="card-text"> <b> Senesi: </b>
                            <?php echo $row['bill_date'] ?>
                        </p>
                        <p class="card-text"> <b> Alyjynyň ady:</b>
                            <?php echo $row['receiver_name'] ?>
                        </p>
                        <p class="card-text"> <b> Elektron poçtasy:</b>
                            <?php echo $row['receiver_email'] ?>
                        </p>
                        <p class="card-text"> <b> Alyjynyň salgysy:</b>
                            <?php echo $row['receiver_address'] ?>
                        </p>
                        <p class="card-text"> <b> Eltip bermek üçin tölegler :</b>
                            <?php echo $row['delivery_charges'] ?>
                        </p>
                        <p class="card-text"> <b> Ýagdaýy :</b>
                            <?php echo $row['status'] ?>
                        </p>
                        <button class="btn btn-outline-secondary" onclick="window.print()">Print</button>
                    </div>
                </div>
            </div>
            <?php elseif ($trackingNumber !== "") : ?>
            <div class="alert alert-danger mt-3">Gözleg belgisi tapylmady.</div>
            <?php endif; ?>
        </div>
    </main>
    <!-- Include Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>

<?php
// require('footer.inc.php');
?>